import { UseFormWatch } from "react-hook-form";
import { AddUserSchemaT } from "../../_schema";
import { Permission, RoleT } from "@/types/roleAndPermissions";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { useState } from "react";
import { StrReplacer } from "@/lib/utils";
import { ChevronsDown, EyeIcon, EyeOffIcon } from "lucide-react";
import style from "../../style.module.scss";
import { PlaceholdersT } from "../page";

type FormRevieweT = {
  watch: UseFormWatch<AddUserSchemaT>;
  roleData: RoleT[] | undefined;
  permissionsData: Permission[] | undefined;
  placeholder: PlaceholdersT | undefined;
};

export default function FormReviewe({
  watch,
  roleData,
  permissionsData,
  placeholder,
}: FormRevieweT) {
  const name = watch("user.name");
  const email = watch("user.email");
  const role = watch("role_id");
  const permission = watch("permissions") as string[];

  const roleName = roleData?.find((dt) => dt.id === Number(role));

  const permissionList = permissionsData?.filter((permissionData) =>
    permission.some((selected) => permissionData.id === Number(selected))
  );

  return (
    <div className="right-card min-h-[40rem] bg-yellowish/60 rounded-sm flex flex-col items-center py-20 space-y-10">
      <Avatar className="w-28 h-28">
        <AvatarImage src="/assets/images/user.png" />
        <AvatarFallback>Profile</AvatarFallback>
      </Avatar>

      <p className="text-danger">Name : {name || "Name"}</p>

      <p className="text-danger">Email : {email || "example@example.com"}</p>

      <p className="text-danger">Report To : {placeholder?.report_to}</p>

      <p className="text-danger">Role : {roleName?.name}</p>
      <p className="text-danger font-semibold">
        Below Are the Permissions Employee has{" "}
        <ChevronsDown className="w-8 inline-block" />
      </p>

      <div className="flex flex-wrap gap-5 mx-10">
        {permissionList?.map((item, index) => {
          return (
            <p
              key={index}
              className={`text-sm text-danger  leading-none peer-disabled:cursor-not-allowed peer-disabled:opacity-70 ${style.permissionList}`}
            >
              {item.name}
            </p>
          );
        })}
      </div>
    </div>
  );
}

function PasswordToggler({ password }: { password: string }) {
  const [show, setShow] = useState(false);
  const pasLen = StrReplacer(password);
  function toggle() {
    setShow((prev) => !prev);
  }

  return (
    <div className="flex gap-8 items-center">
      <p className="inline-block align">{show ? password : pasLen}</p>
      {show ? (
        <EyeOffIcon className="scale-75" onClick={() => toggle()} />
      ) : (
        <EyeIcon className="scale-75" onClick={() => toggle()} />
      )}
    </div>
  );
}
